package com.yeejoin.amos.api.tool.face.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.DataBaseModel;
import com.yeejoin.amos.api.tool.face.orm.dao.DataBaseMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.DataBase;
import com.yeejoin.amos.api.tool.face.util.AESUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.sql.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 服务实现类
 *
 * @author r
 */


@Service
public class DataBaseService extends BaseService<DataBaseModel, DataBase, DataBaseMapper> {
    @Autowired
    private DataBaseMapper dataBaseMapper;

    /**
     * 分页查询
     */
    public Page<DataBaseModel> queryForDataBasePage(Page<DataBaseModel> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<DataBaseModel> queryForDataBaseList() {
        return this.queryForList("", false);
    }

    public List<DataBaseModel> queryForDbInfoListByApiSource(String apiSource) {
        return this.queryForList("", false, apiSource);
    }

    public Long[] stringToLong(String sequenceNbrs) {
        String[] seqs = sequenceNbrs.split(",");
        Long[] seq = new Long[seqs.length];
        for (int i = 0; i < seqs.length; i++) {
            seq[i] = Long.parseLong(seqs[i]);
        }
        return seq;
    }

    public String[] getDataBaseName(Connection connection) throws ClassNotFoundException, SQLException {
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW DATABASES");
        String[] result = new String[1000];
        int count = 0;
        while (rs.next()) {
            result[count++] = rs.getString(1);
        }
        return result;
    }

    public List<DataBaseModel> refreshDataBase(DataBaseModel dataBaseModel) throws Exception {
        this.remove(new QueryWrapper<>());
        //连接数据库
        String url = "jdbc:mysql://" + dataBaseModel.getIp() + ":" + dataBaseModel.getPort() + "/";
        String user = dataBaseModel.getUserName();
        String pwd = dataBaseModel.getPassWord();
        Class.forName("com.mysql.cj.jdbc.Driver");
        Connection connection = DriverManager.getConnection(url, user, pwd);

         pwd = AESUtils.encrypt(pwd);
        if (connection == null)
            return null;

        List<DataBaseModel> dataBaseModels = new ArrayList<>();
        Collection<DataBase> dataBases = new ArrayList<>();
        String[] dataBaseName = this.getDataBaseName(connection);
        for (String name : dataBaseName) {
            if (name == null)
                break;
            DataBaseModel model = new DataBaseModel(name, dataBaseModel.getIp(), dataBaseModel.getPort(), name, user, pwd);
            dataBaseModels.add(model);
            DataBase dataBase = this.prepareEntity(model);
            dataBases.add(dataBase);
        }
        this.saveBatch(dataBases);

        connection.close();
        return dataBaseModels;
    }

    public Connection connectNewDatabase(DataBaseModel dataBaseModel) throws Exception {
        // 加载数据库驱动
        Class.forName("com.mysql.cj.jdbc.Driver");
        // 连接新增的数据库
        String dbUrl = "jdbc:mysql://" + dataBaseModel.getIp() + ":" + dataBaseModel.getPort() + "/" + dataBaseModel.getDbName();
        dataBaseModel.setPassWord(AESUtils.decrypt(dataBaseModel.getPassWord()));
        return DriverManager.getConnection(dbUrl, dataBaseModel.getUserName(), dataBaseModel.getPassWord());
    }

}
