package com.yeejoin.amos.api.tool.face.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.PicModel;
import com.yeejoin.amos.api.tool.face.model.TplModel;
import com.yeejoin.amos.api.tool.face.model.TplVoModel;
import com.yeejoin.amos.api.tool.face.orm.dao.TplMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.Tpl;
import com.yeejoin.amos.api.tool.face.util.PicUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.utils.StringUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Service
public class TplService extends BaseService<TplModel, Tpl, TplMapper> {

    @Autowired
    TplService tplService;
    @Autowired
    TplCateService tplCateService;
    @Autowired
    VisualDesignerService visualDesignerService;

    /**
     * 分页查询
     */
    public Page<TplModel> queryForTplPage(Page<TplModel> page, Long categorySeq, String displayName) {
        return this.queryForPage(page, null, false, categorySeq, displayName);
    }

    /**
     * 列表查询
     */
    public List<TplModel> queryForTplListByCategorySeq(Long categorySeq) {
        return this.queryForList("", false, categorySeq);
    }

    /**
     * 列表查询
     */
    public List<TplModel> queryForTplList() {
        return this.queryForList("", false);
    }


    /**
     * TplVoModel转化TplModel
     */
    public TplModel convertModel(TplVoModel tplVoModel, TplModel tplModel) throws NoSuchFieldException, IllegalAccessException {
        BeanUtils.copyProperties(tplVoModel, tplModel, "thumbs", "sketches", "contentStr");
        //判定thumbs为空
        if (tplVoModel.getThumbs().size() != 0)
            tplModel.setThumb(PicUtil.objectListToUrl(tplVoModel.getThumbs()));
//            tplModel.setThumb(tplVoModel.getThumbs().get(0).getUrl());
//        判定sketch为空
        if (tplVoModel.getSketches().size() != 0)
            tplModel.setSketch(PicUtil.objectListToUrl(tplVoModel.getSketches()));
//            tplModel.setSketch(tplVoModel.getSketches().get(0).getUrl());
        tplModel.setContent(JSON.parseObject(tplVoModel.getContentStr()));
        return tplModel;
    }

    /**
     * 删除多个模板
     */
    public void deleteByIds(String sequenceNbr) {
        String[] seqs = sequenceNbr.split(",");
        Long[] seq = new Long[seqs.length];
        for (int i = 0; i < seq.length; i++) {
            seq[i] = Long.parseLong(seqs[i]);
            this.removeById(seq[i]);
        }
    }

    /**
     * 读取json文件
     */
    public String readMultipartFile(MultipartFile multipartFile) throws IOException {
        Reader reader = new InputStreamReader(multipartFile.getInputStream(), "utf-8");
        int ch = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((ch = reader.read()) != -1) {
            stringBuffer.append((char) ch);
        }
        reader.close();
        return stringBuffer.toString();
    }

    public TplVoModel convertVoModel(TplModel tplModel){
        TplVoModel tplVoModel = new TplVoModel();
        BeanUtils.copyProperties(tplModel, tplVoModel);
        if(tplModel.getSketch() != null)
            tplVoModel.setSketches(this.urlToPicModel(tplModel.getSketch()));
        if (tplModel.getThumb() != null)
            tplVoModel.setThumbs(this.urlToPicModel(tplModel.getThumb()));
        System.out.println(tplVoModel.getThumbs());
        return tplVoModel;
    }

    public String getUid(){
        UUID uuid= UUID.randomUUID();
        String str = uuid.toString();
        return str.replace("-", "");
    }

    public List<PicModel> urlToPicModel(String url){
        List<PicModel> picModels = new ArrayList<>();
        PicModel picModel = new PicModel("", this.getUid(), url, "done");
        picModels.add(picModel);
        return picModels;
    }


}
