package com.yeejoin.amos.api.tool.face.service;

import com.yeejoin.amos.api.tool.face.orm.entity.TableColumn;
import com.yeejoin.amos.api.tool.utils.DataBaseUtils;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class TransferDataService {
    private static final String TABLE_DES = "mcb_warning_base_source_attribution";
    private static final String TABLE_ORI = "qms_explorer";
    private static final String DBNAME_DES = "amos_mcb";
    private static final String DBNAME_ORI = "amos_studio";


    public Connection connectDataBase(String dataBaseName) throws ClassNotFoundException, SQLException {
        // 加载数据库驱动
        Class.forName("com.mysql.cj.jdbc.Driver");
        // 生成url
        String dbUrl = "jdbc:mysql://172.16.3.18:3306/" + dataBaseName;
        // 连接数据库
        return DriverManager.getConnection(dbUrl, "root", "Yeejoin@2020");
    }

    public void transferData() throws SQLException, ClassNotFoundException {
        Connection connection = this.connectDataBase(DBNAME_ORI);
        List<Map<String,Object>> maps = DataBaseUtils.getMaps("SELECT * FROM " + TABLE_ORI + " ;" , connection);
         connection.close();
         connection = this.connectDataBase(DBNAME_DES);
        List<TableColumn> columns = DataBaseUtils.getTableColumn(TABLE_DES,connection);
        List<Map<String,Object>> dataList = this.convertDataMap(maps, columns);
        System.out.println(DataBaseUtils.getInsertSQL(dataList,columns,TABLE_DES));
    }

    public List<Map<String, Object>> convertDataMap(List<Map<String, Object>> maps, List<TableColumn> columns) {
        List<Map<String, Object>> dataList = new ArrayList<>();
        for (Map<String, Object> map : maps) {
            Map<String, Object> data = new HashMap<>();
            for (TableColumn column : columns) {
                data.put(column.getColumnName(), null);
            }
            data.replace("SEQUENCE_NBR", map.get("SEQUENCE_NBR"));
            data.replace("NAME", map.get("RESOURCE_NAME"));
            data.replace("PARENT_ID", map.get("PARENT_ID"));
            data.replace("CODE", map.get("AGENCY_CODE"));
            data.replace("REC_USER_ID", map.get("REC_USER_ID"));
            data.replace("REC_DATE", map.get("REC_DATE"));
            dataList.add(data);
        }
        return dataList;
    }
}
